/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.listeners;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.TreeAssistDebugger;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.events.TASaplingBreakEvent;
import net.slipcor.treeassist.events.TATreeBrokenEvent;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.utils.MaterialUtils;
import net.slipcor.treeassist.yml.Language;
import net.slipcor.treeassist.yml.MainConfig;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.TreeType;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.event.block.BlockPlaceEvent;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.PlayerDropItemEvent;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.event.player.PlayerSwapHandItemsEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class TreeAssistPlayerListener
implements Listener {
    public static TreeAssistDebugger debug;
    public TreeAssist plugin;
    private final String debugToolDisplayName = "" + ChatColor.GREEN + ChatColor.ITALIC + "TreeAssist Debug";
    private final String growToolDisplayName = "" + ChatColor.GREEN + ChatColor.ITALIC + "TreeAssist Grow";
    private final String protectToolDisplayName = "" + ChatColor.GREEN + ChatColor.ITALIC + "TreeAssist Protect";
    private static final List<BlockBreakEvent> ignoring;
    private static final Map<Player, TreeStructure> destroyers;

    public TreeAssistPlayerListener(TreeAssist instance) {
        this.plugin = instance;
    }

    public static void ignore(BlockBreakEvent event) {
        ignoring.add(event);
    }

    @EventHandler(ignoreCancelled=true)
    public void onInteract(PlayerInteractEvent event) {
        if (!this.plugin.isActive(event.getPlayer().getWorld())) {
            debug.i("not in this world: " + event.getPlayer().getWorld().getName());
            return;
        }
        if (event.hasItem() && event.hasBlock()) {
            Block clicked;
            if (this.isProtectTool(event.getPlayer().getInventory().getItemInMainHand())) {
                Block clicked2 = event.getClickedBlock();
                if (clicked2 != null && MaterialUtils.isSapling(clicked2.getType())) {
                    if (this.plugin.saplingLocationList.contains(clicked2.getLocation())) {
                        this.plugin.saplingLocationList.remove(clicked2.getLocation());
                        TreeAssist.instance.sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.SUCCESSFUL_PROTECT_OFF.parse());
                    } else {
                        this.plugin.saplingLocationList.add(clicked2.getLocation());
                        TreeAssist.instance.sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.SUCCESSFUL_PROTECT_ON.parse());
                    }
                }
            } else if (this.isGrowTool(event.getPlayer().getInventory().getItemInMainHand())) {
                if (event.getBlockFace().equals((Object)BlockFace.UP)) {
                    ItemStack tool = event.getPlayer().getInventory().getItemInMainHand();
                    TreeType type = TreeType.valueOf((String)((String)tool.getItemMeta().getLore().get(0)));
                    Block destination = event.getClickedBlock().getRelative(BlockFace.UP);
                    for (int i = 0; i < 20; ++i) {
                        if (!destination.getWorld().generateTree(destination.getLocation(), type)) continue;
                        return;
                    }
                    TreeAssist.instance.sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.ERROR_GROW.parse());
                }
            } else if (this.isDebugTool(event.getPlayer().getInventory().getItemInMainHand()) && (clicked = event.getClickedBlock()) != null && MaterialUtils.isLog(clicked.getType())) {
                TreeStructure tree = TreeStructure.discover(event.getPlayer(), clicked);
                if (tree == null) {
                    return;
                }
                if (tree.trunk != null) {
                    tree.trunk.add(clicked);
                }
                event.setCancelled(true);
                if (tree.discoveryResult != null) {
                    tree.discoveryResult.debugShow(event.getPlayer());
                }
            }
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockPlace(BlockPlaceEvent event) {
        if (!this.plugin.isActive(event.getPlayer().getWorld())) {
            debug.i("not in this world: " + event.getPlayer().getWorld().getName());
            return;
        }
        if (TreeStructure.allSaplings.contains(event.getBlockReplacedState().getType())) {
            debug.i("onBlockPlace: this block was a sapling (" + event.getBlockReplacedState().getType());
            return;
        }
        if (this.plugin.config().getBoolean(MainConfig.CFG.PLACED_BLOCKS_ACTIVE) && TreeStructure.allTrunks.contains(event.getBlock().getType())) {
            Block block = event.getBlock();
            this.plugin.blockList.addBlock(block);
            this.plugin.blockList.save();
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onBlockBreak(BlockBreakEvent event) {
        if (ignoring.contains(event)) {
            ignoring.remove(event);
            debug.i("skip this one!");
            return;
        }
        if (!this.plugin.Enabled) {
            debug.i("globally disabled!");
            return;
        }
        if (!this.plugin.isActive(event.getBlock().getWorld())) {
            debug.i("not in this world: " + event.getBlock().getWorld().getName());
            return;
        }
        if (MaterialUtils.isSapling(event.getBlock().getType())) {
            if (this.plugin.saplingLocationList.contains(event.getBlock().getLocation())) {
                TreeAssist.instance.sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.INFO_SAPLING_PROTECTED.parse());
                event.setCancelled(true);
                return;
            }
            TASaplingBreakEvent saplingBreakEvent = new TASaplingBreakEvent(event.getBlock(), event.getBlock().getType());
            TreeAssist.instance.getServer().getPluginManager().callEvent((Event)saplingBreakEvent);
            if (saplingBreakEvent.isCancelled()) {
                debug.i("Another plugin prevented sapling breaking!");
                TreeAssist.instance.sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.INFO_SAPLING_PROTECTED.parse());
                event.setCancelled(true);
                return;
            }
            for (TreeConfig config : TreeAssist.treeConfigs.values()) {
                if (event.getBlock().getType() != config.getMaterial(TreeConfig.CFG.REPLANTING_MATERIAL) || !config.getBoolean(TreeConfig.CFG.REPLANTING_FORCE_PROTECT)) continue;
                TreeAssist.instance.sendPrefixed((CommandSender)event.getPlayer(), Language.MSG.INFO_NEVER_BREAK_SAPLINGS.parse());
                event.setCancelled(true);
                return;
            }
        }
        if (!TreeStructure.allTrunks.contains(event.getBlock().getType())) {
            debug.i("Not a tree block: " + event.getBlock().getType());
            return;
        }
        if (this.plugin.config().getBoolean(MainConfig.CFG.PLACED_BLOCKS_ACTIVE) && this.plugin.blockList.isPlayerPlaced(event.getBlock())) {
            debug.i("User placed block. Removing!");
            this.plugin.blockList.removeBlock(event.getBlock());
            this.plugin.blockList.save();
            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, event.getBlock(), "This is a player placed block! Not a tree to autochop!");
            debug.explain(TreeAssistDebugger.ErrorType.CLEANUP, event.getBlock(), "This is a player placed block! Not a tree to cleanup!");
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, event.getBlock(), "This is a player placed block! Not a valid tree to replant!");
            return;
        }
        Player player = event.getPlayer();
        TreeStructure tree = TreeStructure.discover(player, event.getBlock());
        if (tree == null) {
            debug.explain(TreeAssistDebugger.ErrorType.AUTOCHOP, event.getBlock(), "This is not a valid tree to autochop!");
            debug.explain(TreeAssistDebugger.ErrorType.CLEANUP, event.getBlock(), "This is not a valid tree to cleanup!");
            debug.explain(TreeAssistDebugger.ErrorType.SAPLING, event.getBlock(), "This is not a valid tree to replant!");
            return;
        }
        TATreeBrokenEvent treeEvent = new TATreeBrokenEvent(tree, player, tree.discoveryResult.getTool());
        TreeAssist.instance.getServer().getPluginManager().callEvent((Event)treeEvent);
        if (treeEvent.isCancelled()) {
            debug.i(">>> Cancelled by plugin! <<< Aborting breaking!");
            event.setCancelled(true);
            return;
        }
        if (tree.discoveryResult.isCancel()) {
            event.setCancelled(true);
        }
        tree.discoveryResult.commitActions(event.getBlock(), player);
    }

    @EventHandler(ignoreCancelled=true)
    public void onPickUpEvent(EntityPickupItemEvent event) {
        if (!this.plugin.isActive(event.getItem().getWorld())) {
            debug.i("not in this world: " + event.getItem().getWorld().getName());
            return;
        }
        debug.i("Picking up : " + event.getItem().getType() + " >> " + event.getItem().getClass());
        if (event.getItem() instanceof FallingBlock) {
            debug.i("Falling block picked up!");
            if (BlockUtils.removeIfFallen((FallingBlock)event.getItem())) {
                event.setCancelled(true);
                debug.i("Event cancelled!");
            } else {
                debug.i("Event not cancelled!");
            }
        }
    }

    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!this.plugin.config().getBoolean(MainConfig.CFG.GENERAL_TOGGLE_DEFAULT)) {
            this.plugin.toggleGlobal(event.getPlayer().getName());
        }
        if (event.getPlayer().isOp() && this.plugin.getUpdater() != null) {
            this.plugin.getUpdater().message((CommandSender)event.getPlayer());
        }
    }

    public static void addDestroyer(Player player, TreeStructure tree) {
        destroyers.put(player, tree);
    }

    public static void removeDestroyer(Player player, TreeStructure tree) {
        if (player == null) {
            return;
        }
        if (tree.equals(destroyers.get(player))) {
            destroyers.remove(player);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onToolClick(InventoryClickEvent event) {
        if (!this.plugin.isActive(event.getWhoClicked().getWorld())) {
            debug.i("not in this world: " + event.getWhoClicked().getWorld().getName());
            return;
        }
        if (destroyers.containsKey((Player)event.getWhoClicked())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onToolSwitch(PlayerSwapHandItemsEvent event) {
        if (!this.plugin.isActive(event.getPlayer().getWorld())) {
            debug.i("not in this world: " + event.getPlayer().getWorld().getName());
            return;
        }
        if (destroyers.containsKey(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onToolDrop(PlayerDropItemEvent event) {
        if (!this.plugin.isActive(event.getPlayer().getWorld())) {
            debug.i("not in this world: " + event.getPlayer().getWorld().getName());
            return;
        }
        if (destroyers.containsKey(event.getPlayer())) {
            event.setCancelled(true);
        }
    }

    public ItemStack getDebugTool() {
        ItemStack item = new ItemStack(Material.GOLDEN_HOE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.debugToolDisplayName);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getGrowTool(TreeType treeType) {
        ItemStack item = new ItemStack(Material.GOLDEN_HOE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.growToolDisplayName);
        ArrayList<String> lore = new ArrayList<String>();
        lore.add(treeType.name());
        meta.setLore(lore);
        item.setItemMeta(meta);
        return item;
    }

    public ItemStack getProtectionTool() {
        ItemStack item = new ItemStack(Material.GOLDEN_HOE);
        ItemMeta meta = item.getItemMeta();
        meta.setDisplayName(this.protectToolDisplayName);
        item.setItemMeta(meta);
        return item;
    }

    public boolean isDebugTool(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(this.debugToolDisplayName);
    }

    public boolean isGrowTool(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(this.growToolDisplayName);
    }

    public boolean isProtectTool(ItemStack item) {
        return item != null && item.hasItemMeta() && item.getItemMeta().hasDisplayName() && item.getItemMeta().getDisplayName().equals(this.protectToolDisplayName);
    }

    static {
        ignoring = new ArrayList<BlockBreakEvent>();
        destroyers = new HashMap<Player, TreeStructure>();
    }
}

