/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.core;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.core.CoreCommand;
import org.bukkit.command.CommandSender;

public class CoreTabCompleter {
    final boolean shorthand;

    public CoreTabCompleter(boolean shorthand) {
        this.shorthand = shorthand;
    }

    public List<String> getMatches(CommandSender sender, List<CoreCommand> commandList, String[] args) {
        ArrayList<String> matches = new ArrayList<String>();
        if (args.length < 1 || args[0] == null || args[0].equals("")) {
            for (CoreCommand command : commandList) {
                if (!command.hasPerms(sender)) continue;
                matches.addAll(command.getMain());
                if (!this.shorthand) continue;
                matches.addAll(command.getShort());
            }
            Collections.sort(matches);
            return matches;
        }
        if (args.length == 1) {
            String typed = args[0].toLowerCase();
            for (CoreCommand command : commandList) {
                if (!command.hasPerms(sender)) continue;
                for (String mainCmd : command.getMain()) {
                    if (!mainCmd.toLowerCase().startsWith(typed)) continue;
                    matches.add(mainCmd);
                }
                if (!this.shorthand) continue;
                for (String shortHand : command.getShort()) {
                    if (!shortHand.toLowerCase().startsWith(typed)) continue;
                    matches.add(shortHand);
                }
            }
            Collections.sort(matches);
            return matches;
        }
        String typed = args[0].toLowerCase();
        for (CoreCommand command : commandList) {
            if (!command.hasPerms(sender)) continue;
            for (String mainCmd : command.getMain()) {
                if (!mainCmd.toLowerCase().equals(typed)) continue;
                return command.completeTab(args);
            }
            if (!this.shorthand) continue;
            for (String shortHand : command.getShort()) {
                if (!shortHand.toLowerCase().equals(typed)) continue;
                return command.completeTab(args);
            }
        }
        return matches;
    }
}

