/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.yml.Language;
import org.apache.commons.lang.StringUtils;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandFindForest
extends CoreCommand {
    Map<String, List<Biome>> biomeMap = new HashMap<String, List<Biome>>();

    public CommandFindForest(CorePlugin plugin) {
        super(plugin, "treeassist.findforest", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
        int b;
        int a;
        String[] chunks;
        String version = Bukkit.getServer().getBukkitVersion();
        try {
            chunks = version.split("-")[0].split("\\.");
        }
        catch (Exception e) {
            chunks = new String[]{"1", "11"};
        }
        try {
            a = Integer.parseInt(chunks[0]);
        }
        catch (Exception e) {
            a = 1;
        }
        try {
            b = Integer.parseInt(chunks[1]);
        }
        catch (Exception e) {
            b = 9;
        }
        if (a > 1 || b > 17) {
            return;
        }
        this.biomeMap.put("ACACIA", Arrays.asList(Biome.SAVANNA));
        this.biomeMap.put("BIRCH", Arrays.asList(Biome.BIRCH_FOREST, Biome.BIRCH_FOREST_HILLS));
        this.biomeMap.put("DARK_OAK", Arrays.asList(Biome.DARK_FOREST));
        this.biomeMap.put("OAK", Arrays.asList(Biome.FOREST));
        this.biomeMap.put("JUNGLE", Arrays.asList(Biome.JUNGLE, Biome.JUNGLE_HILLS));
        this.biomeMap.put("SPRUCE", Arrays.asList(Biome.TAIGA, Biome.GIANT_TREE_TAIGA));
        this.biomeMap.put("MUSHROOM", Arrays.asList(Biome.MUSHROOM_FIELDS, Biome.MUSHROOM_FIELD_SHORE));
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_FINDFOREST.parse());
            return;
        }
        if (this.biomeMap.isEmpty()) {
            TreeAssist.instance.sendPrefixed(sender, "Please use '/locate biome' or '/locatebiome' on servers below 1.19");
            return;
        }
        if (!(sender instanceof Player)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_ONLY_PLAYERS.parse());
            return;
        }
        if (args.length < 2) {
            TreeAssist.instance.sendPrefixed(sender, ChatColor.DARK_RED + this.getShortInfo());
            return;
        }
        List<Biome> biomes = this.biomeMap.get(args[1].toUpperCase());
        if (biomes == null) {
            String list = StringUtils.join((Object[])this.biomeMap.keySet().toArray(), (String)", ");
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_INVALID_ARGUMENT_LIST.parse(list));
            return;
        }
        Player player = (Player)sender;
        int distanceSquared = Integer.MAX_VALUE;
        Block foundBlock = null;
        for (int x = -20; x <= 20; x += 1 + Math.abs(x) / 5) {
            for (int z = -20; z <= 20; z += 1 + Math.abs(z) / 5) {
                Block block = player.getLocation().getBlock().getRelative(x * 50, 0, z * 50);
                if (!biomes.contains(block.getBiome()) || !(block.getLocation().distanceSquared(player.getLocation()) < (double)distanceSquared)) continue;
                distanceSquared = (int)block.getLocation().distanceSquared(player.getLocation());
                foundBlock = block;
            }
        }
        if (distanceSquared < Integer.MAX_VALUE) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_FINDFOREST.parse(foundBlock.getX() + "/" + foundBlock.getY() + "/" + foundBlock.getZ()));
        } else {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_FINDFOREST.parse(args[1]));
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            results.addAll(this.biomeMap.keySet());
            Collections.sort(results);
            return results;
        }
        if (args.length > 2) {
            return results;
        }
        for (String treeType : this.biomeMap.keySet()) {
            if (!treeType.startsWith(args[1].toUpperCase())) continue;
            results.add(treeType);
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("findforest");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!ff");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist findforest [treetype] - find biome based on tree type";
    }
}

