/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.yml.Language;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandDebugTool
extends CoreCommand {
    public CommandDebugTool(CorePlugin plugin) {
        super(plugin, "treeassist.debugtool", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_TOGGLE_DEBUGTOOL.parse());
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            boolean found = false;
            for (ItemStack item : player.getInventory().getContents()) {
                if (item == null || !item.hasItemMeta() || !TreeAssist.instance.getPlayerListener().isDebugTool(item)) continue;
                player.getInventory().removeItem(new ItemStack[]{item});
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_DEBUGTOOL_OFF.parse());
                found = true;
                break;
            }
            if (!found) {
                player.getInventory().addItem(new ItemStack[]{TreeAssist.instance.getPlayerListener().getDebugTool()});
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_DEBUGTOOL_ON.parse());
            }
            return;
        }
        TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_ONLY_PLAYERS.parse());
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("debugtool");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!dt");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist debugtool - toggle the debug tool";
    }

    @Override
    public List<String> completeTab(String[] strings) {
        return new ArrayList<String>();
    }
}

