/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.utils;

import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Material;

public class MaterialUtils {
    private MaterialUtils() {
    }

    public static boolean isAir(Material mat) {
        return mat == null || mat == Material.AIR || mat == Material.CAVE_AIR || mat == Material.VOID_AIR;
    }

    public static boolean isLeaf(Material material) {
        return TreeStructure.allExtras.contains(material);
    }

    public static boolean isLog(Material material) {
        return TreeStructure.allTrunks.contains(material);
    }

    public static boolean isMushroom(Material material) {
        switch (material) {
            case BROWN_MUSHROOM: 
            case BROWN_MUSHROOM_BLOCK: 
            case MUSHROOM_STEM: 
            case RED_MUSHROOM: 
            case RED_MUSHROOM_BLOCK: {
                return true;
            }
        }
        return false;
    }

    public static boolean isSapling(Material material) {
        if (material == Material.AIR) {
            return false;
        }
        for (TreeConfig config : TreeAssist.treeConfigs.values()) {
            if (material != config.getMaterial(TreeConfig.CFG.REPLANTING_MATERIAL)) continue;
            return true;
        }
        return false;
    }
}

