/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Set;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.TreeAssistDebugger;
import net.slipcor.treeassist.discovery.LeavesStructure;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.events.TALeafDecay;
import net.slipcor.treeassist.externals.AuraSkillsHook;
import net.slipcor.treeassist.externals.AureliumSkillsHook;
import net.slipcor.treeassist.externals.JobsHook;
import net.slipcor.treeassist.externals.mcMMOHook;
import net.slipcor.treeassist.listeners.TreeAssistPlayerListener;
import net.slipcor.treeassist.runnables.CleanRunner;
import net.slipcor.treeassist.utils.MaterialUtils;
import net.slipcor.treeassist.yml.MainConfig;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.entity.FallingBlock;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.scoreboard.Objective;
import org.bukkit.scoreboard.Score;
import org.bukkit.util.Vector;

public class BlockUtils {
    public static TreeAssistDebugger debug;
    public static Boolean useFallingBlock;
    private static final List<FallingBlock> fallingBlocks;

    private BlockUtils() {
    }

    @Deprecated
    public static void breakBlock(Block block) {
        BlockUtils.breakBlock(null, block, null, 0);
    }

    public static void breakBlock(Player player, Block block, ItemStack tool, int baseHeight) {
        if (useFallingBlock == null) {
            useFallingBlock = TreeAssist.instance.config().getBoolean(MainConfig.CFG.DESTRUCTION_FALLING_BLOCKS);
        }
        if (useFallingBlock.booleanValue()) {
            Collection drops;
            Collection collection = drops = tool == null ? block.getDrops() : block.getDrops(tool);
            if (player == null) {
                drops.clear();
            }
            BlockData data = block.getBlockData();
            block.setType(Material.AIR, true);
            FallingBlock falling = block.getWorld().spawnFallingBlock(block.getLocation().add(0.5, 0.0, 0.5), data);
            falling.setDropItem(false);
            if (player != null && TreeAssist.instance.config().getBoolean(MainConfig.CFG.DESTRUCTION_FALLING_BLOCKS_FANCY)) {
                falling.setGravity(false);
                double level = block.getY() - baseHeight;
                Vector looking = player.getLocation().getDirection().multiply(level /= 80.0);
                falling.setVelocity(new Vector(looking.getX(), -level, looking.getZ()));
                Bukkit.getScheduler().runTaskLater((Plugin)TreeAssist.instance, () -> falling.setGravity(true), 30L);
            }
            fallingBlocks.add(falling);
            if (player != null) {
                player.sendBlockChange(block.getLocation(), block.getBlockData());
            }
            for (ItemStack item : drops) {
                if (item.getType().isAir()) continue;
                block.getWorld().dropItemNaturally(block.getLocation(), item);
            }
        } else if (tool == null) {
            block.setType(Material.AIR, true);
            if (player != null) {
                player.sendBlockChange(block.getLocation(), block.getBlockData());
            }
        } else {
            block.breakNaturally(tool);
        }
    }

    private static boolean isLonelyLeaf(Block block, List<Material> extras, List<Material> trunks, List<Material> naturals) {
        if (!extras.contains(block.getType())) {
            return false;
        }
        TALeafDecay event = new TALeafDecay(block);
        TreeAssist.instance.getServer().getPluginManager().callEvent((Event)event);
        if (!event.isCancelled()) {
            World world = block.getWorld();
            int preventCheck = 0;
            for (int x = block.getX() - 2; x <= block.getX() + 2; ++x) {
                for (int y = block.getY() - 2; y <= block.getY() + 2; ++y) {
                    for (int z = block.getZ() - 2; z <= block.getZ() + 2; ++z) {
                        if ((preventCheck += BlockUtils.decayPreventionValue(world.getBlockAt(x, y, z), trunks, naturals)) <= 4) continue;
                        return false;
                    }
                }
            }
            return true;
        }
        return false;
    }

    public static void breakRadiusLeaves(Block block, TreeConfig config) {
        debug.i("breaking radius leaves around " + BlockUtils.printBlock(block));
        TALeafDecay event = new TALeafDecay(block);
        TreeAssist.instance.getServer().getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            debug.i("someone cancelled us!");
            return;
        }
        TreeAssist.instance.blockList.logBreak(block, null);
        debug.i("breaking block in the middle of radius leaves: " + BlockUtils.printBlock(block));
        BlockUtils.breakBlock(null, block, new ItemStack(Material.AIR, 1), 0);
        World world = block.getWorld();
        int x = block.getX();
        int y = block.getY();
        int z = block.getZ();
        List<Material> extras = config.getMaterials(TreeConfig.CFG.BLOCKS_MATERIALS);
        List<Material> trunks = config.getMaterials(TreeConfig.CFG.TRUNK_MATERIALS);
        List<Material> naturals = config.getMaterials(TreeConfig.CFG.NATURAL_BLOCKS);
        if (extras.contains(Material.OAK_LEAVES) && !trunks.contains(Material.JUNGLE_LOG)) {
            trunks.add(Material.JUNGLE_LOG);
        }
        ArrayList<BasicVector> preventList = new ArrayList<BasicVector>();
        ArrayList<BasicVector> calculateList = new ArrayList<BasicVector>();
        ArrayList<Block> leafBlocks = new ArrayList<Block>();
        for (int x2 = -10; x2 < 11; ++x2) {
            for (int y2 = -4; y2 < 5; ++y2) {
                for (int z2 = -10; z2 < 11; ++z2) {
                    Block checkBlock = world.getBlockAt(x + x2, y + y2, z + z2);
                    if (extras.contains(checkBlock.getType())) {
                        if (x2 <= -8 || x2 >= 9 || y2 <= -2 || y2 >= 3 || z2 <= -8 || z2 >= 9 || x2 == 0 || y2 == 0 || z2 == 0) continue;
                        leafBlocks.add(checkBlock);
                        continue;
                    }
                    int prevent = BlockUtils.decayPreventionValue(checkBlock, trunks, naturals);
                    if (prevent > 4) {
                        preventList.add(new BasicVector(checkBlock.getX(), checkBlock.getY(), checkBlock.getZ()));
                        continue;
                    }
                    if (prevent <= 0) continue;
                    calculateList.add(new BasicVector(checkBlock.getX(), checkBlock.getY(), checkBlock.getZ()));
                }
            }
        }
        if (leafBlocks.size() > 0) {
            for (BasicVector vector : preventList) {
                int pos = 0;
                while (pos < leafBlocks.size()) {
                    Block leafBlock = (Block)leafBlocks.get(pos);
                    if (Math.abs(leafBlock.getX() - vector.x) <= 2 && Math.abs(leafBlock.getY() - vector.y) <= 2 && Math.abs(leafBlock.getZ() - vector.z) <= 2) {
                        leafBlocks.remove(pos);
                        continue;
                    }
                    ++pos;
                }
            }
        }
        int pos = 0;
        block5: while (pos < leafBlocks.size()) {
            Block leafBlock = (Block)leafBlocks.get(pos);
            TALeafDecay decayEvent = new TALeafDecay(leafBlock);
            TreeAssist.instance.getServer().getPluginManager().callEvent((Event)decayEvent);
            if (!decayEvent.isCancelled()) {
                int prevent = 0;
                for (BasicVector vector : calculateList) {
                    if (Math.abs(leafBlock.getX() - vector.x) > 2 || Math.abs(leafBlock.getY() - vector.y) > 2 || Math.abs(leafBlock.getZ() - vector.z) > 2 || ++prevent <= 4) continue;
                    leafBlocks.remove(pos);
                    continue block5;
                }
            }
            ++pos;
        }
        LinkedHashSet<Block> breakables = new LinkedHashSet<Block>(leafBlocks);
        int delay = config.getInt(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_DELAY);
        if (delay < 0) {
            for (Block bye : breakables) {
                TreeAssist.instance.blockList.logBreak(bye, null);
                debug.i("breaking block instantly because of instant leaf decay: " + BlockUtils.printBlock(bye));
                BlockUtils.breakBlock(null, bye, new ItemStack(Material.AIR, 1), 0);
            }
        } else {
            BlockUtils.sortInsideOut(breakables, block);
            if (breakables.size() > 0) {
                LeavesStructure leaves = new LeavesStructure(config, breakables);
                TreeAssist.instance.treeAdd(leaves);
                CleanRunner cleaner = new CleanRunner(leaves, delay, new LinkedHashSet<Block>(breakables), Material.AIR, true, new ArrayList<Material>());
                cleaner.runTaskTimer((Plugin)TreeAssist.instance, delay, delay);
            }
        }
    }

    public static void updateMining(Player player, Material blockMaterial, int amount) {
        for (Objective o : player.getScoreboard().getObjectives()) {
            if (!o.getCriteria().contains("mined") || !o.getCriteria().contains(blockMaterial.name().toLowerCase())) continue;
            Score score = o.getScore(player.getName());
            score.setScore(score.getScore() + amount);
        }
    }

    public static void updatePickup(Player player, Material blockMaterial, int amount) {
        for (Objective o : player.getScoreboard().getObjectives()) {
            if (!o.getCriteria().contains("picked_up") || !o.getCriteria().contains(blockMaterial.name().toLowerCase())) continue;
            Score score = o.getScore(player.getName());
            score.setScore(score.getScore() + amount);
        }
    }

    public static void callExternals(Block block, Player player, boolean fullTree) {
        boolean leaf = TreeStructure.allExtras.contains(block.getType());
        if (!leaf && player != null) {
            double value;
            if (TreeAssist.instance.aurelium) {
                if (fullTree) {
                    value = TreeAssist.instance.config().getDouble(MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS_TREE);
                    if (value > 0.0) {
                        TreeStructure.debug.i("Adding AureliumSkills Tree EXP!");
                        AureliumSkillsHook.addAureliumExp(player, value);
                    } else {
                        TreeStructure.debug.i("AureliumSkills selected but no exp amount given?!");
                    }
                } else {
                    value = TreeAssist.instance.config().getDouble(MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS_BLOCK);
                    if (value > 0.0) {
                        TreeStructure.debug.i("Adding AureliumSkills Block EXP!");
                        AureliumSkillsHook.addAureliumExp(player, value);
                    } else {
                        TreeStructure.debug.i("AureliumSkills selected but no exp amount given?!");
                    }
                }
            }
            if (TreeAssist.instance.auraskills) {
                if (fullTree) {
                    value = TreeAssist.instance.config().getDouble(MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS_TREE);
                    if (value > 0.0) {
                        TreeStructure.debug.i("Adding AuraSkills Tree EXP!");
                        AuraSkillsHook.addAuraExp(player, value);
                    } else {
                        TreeStructure.debug.i("AuraSkills selected but no exp amount given?!");
                    }
                } else {
                    value = TreeAssist.instance.config().getDouble(MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS_BLOCK);
                    if (value > 0.0) {
                        TreeStructure.debug.i("Adding AuraSkills Block EXP!");
                        AuraSkillsHook.addAuraExp(player, value);
                    } else {
                        TreeStructure.debug.i("AuraSkills selected but no exp amount given?!");
                    }
                }
            }
            if (TreeAssist.instance.mcMMO && fullTree == TreeAssist.instance.config().getBoolean(MainConfig.CFG.PLUGINS_USE_TREEMCMMO)) {
                TreeStructure.debug.i("Adding mcMMO EXP!");
                mcMMOHook.mcMMOAddExp(player, block);
            }
            if (TreeAssist.instance.jobs && fullTree == TreeAssist.instance.config().getBoolean(MainConfig.CFG.PLUGINS_USE_TREEJOBS)) {
                TreeStructure.debug.i("Adding Jobs EXP!");
                JobsHook.addJobsExp(player, block);
            }
            if (TreeAssist.instance.makeEvents && !fullTree) {
                TreeStructure.debug.i("Making custom event!");
                BlockBreakEvent event = new BlockBreakEvent(block, player);
                TreeAssistPlayerListener.ignore(event);
                TreeAssist.instance.getServer().getPluginManager().callEvent((Event)event);
            }
        } else {
            TreeStructure.debug.i("mcMMO: " + TreeAssist.instance.mcMMO);
            TreeStructure.debug.i("jobs: " + TreeAssist.instance.jobs);
            TreeStructure.debug.i("player: " + player);
        }
    }

    private static int decayPreventionValue(Block block, List<Material> trunks, List<Material> naturals) {
        if (trunks.contains(block.getType())) {
            debug.i("prevention 5: " + BlockUtils.printBlock(block));
            return 5;
        }
        if (MaterialUtils.isAir(block.getType()) || TreeStructure.allExtras.contains(block.getType()) || naturals.contains(block.getType())) {
            return 0;
        }
        debug.i("prevention 1: " + BlockUtils.printBlock(block));
        return 1;
    }

    public static boolean removeIfFallen(FallingBlock item) {
        if (fallingBlocks.contains(item)) {
            fallingBlocks.remove(item);
            item.remove();
            return true;
        }
        return false;
    }

    public static void sortBottomUp(Set<Block> set) {
        PriorityQueue<Block> temp = new PriorityQueue<Block>(Comparator.comparingInt(Block::getY));
        temp.addAll(set);
        set.clear();
        set.addAll(temp);
    }

    public static void sortInsideOut(Set<Block> set, Block block) {
        PriorityQueue<Block> temp = new PriorityQueue<Block>((o1, o2) -> (int)(o1.getLocation().distanceSquared(block.getLocation()) - o2.getLocation().distanceSquared(block.getLocation())));
        temp.addAll(set);
        set.clear();
        set.addAll(temp);
    }

    public static String printBlock(Block block) {
        return block.getWorld().getName() + ":" + block.getX() + "/" + block.getY() + "/" + block.getZ() + " - " + block.getType().name();
    }

    static {
        useFallingBlock = null;
        fallingBlocks = new ArrayList<FallingBlock>();
    }

    static class BasicVector {
        int x;
        int y;
        int z;

        BasicVector(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BasicVector vector = (BasicVector)o;
            return this.x == vector.x && this.y == vector.y && this.z == vector.z;
        }

        public int hashCode() {
            return Objects.hash(this.x, this.y, this.z);
        }
    }
}

