/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.runnables;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.runnables.TreeAssistReplantDelay;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.utils.MaterialUtils;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.plugin.Plugin;

public class TreeAssistSaplingSelfPlant
implements Runnable {
    private final TreeConfig config;
    private final Material overrideMaterial;
    private Item drop;
    private UUID id;
    private static final Set<Item> items = new HashSet<Item>();
    private int delay;

    public TreeAssistSaplingSelfPlant(TreeConfig config, Item item, Material material) {
        this.config = config;
        this.drop = item;
        this.id = this.drop.getUniqueId();
        items.add(this.drop);
        this.overrideMaterial = this.drop.getItemStack().getType() == material ? null : material;
        this.delay = config.getInt(TreeConfig.CFG.REPLANTING_DROPPED_SAPLINGS_DELAY, 5);
        if (this.delay < 1) {
            this.delay = 1;
        }
        int radius = config.getInt(TreeConfig.CFG.BLOCKS_MIDDLE_RADIUS);
        ArrayList<TreeStructure> trees = new ArrayList<TreeStructure>(TreeAssist.instance.treesThatQualify(config, item.getLocation().getBlock(), radius * radius));
        for (TreeStructure tree : trees) {
            if (!tree.isValid()) continue;
            tree.addReplantDelay(new TreeAssistReplantDelay(tree, this.findBlock(item), this, this.delay, (Entity)item, true));
            return;
        }
        Bukkit.getScheduler().runTaskLater((Plugin)TreeAssist.instance, (Runnable)this, (long)this.delay);
    }

    private Block findBlock(Item item) {
        Block result = item.getLocation().getBlock();
        int checks = this.config.getInt(TreeConfig.CFG.REPLANTING_CHECK_DEPTH);
        while (checks-- > 0 && !this.config.getMaterials(TreeConfig.CFG.GROUND_BLOCKS).contains(result.getType()) || !result.getType().isSolid()) {
            result = result.getRelative(BlockFace.DOWN);
        }
        if (checks <= 0 || result.getType().equals((Object)Material.BEDROCK)) {
            TreeStructure.debug.i("we did not find a valid block");
            return item.getLocation().getBlock();
        }
        TreeStructure.debug.i("we went down to " + BlockUtils.printBlock(result));
        return result.getRelative(BlockFace.UP);
    }

    @Override
    public void run() {
        if (!items.contains(this.drop)) {
            return;
        }
        if (this.drop.isDead() || !this.drop.isValid()) {
            items.remove(this.drop);
            return;
        }
        Block block = this.drop.getLocation().getBlock();
        List<Material> grounds = this.config.getMaterials(TreeConfig.CFG.GROUND_BLOCKS);
        if (MaterialUtils.isAir(block.getType()) && grounds.contains(block.getRelative(BlockFace.DOWN).getType())) {
            block.setType(this.overrideMaterial == null ? this.config.getMaterial(TreeConfig.CFG.REPLANTING_MATERIAL) : this.overrideMaterial);
            if (this.drop.getItemStack().getAmount() > 1) {
                this.drop.getItemStack().setAmount(this.drop.getItemStack().getAmount() - 1);
                Bukkit.getScheduler().runTaskLater((Plugin)TreeAssist.instance, (Runnable)this, (long)this.delay);
                return;
            }
            this.drop.remove();
        }
    }

    public static void remove(Item item) {
        items.remove(item);
    }
}

