/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.runnables;

import java.util.List;
import java.util.Set;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.TreeAssistDebugger;
import net.slipcor.treeassist.discovery.FailReason;
import net.slipcor.treeassist.discovery.LeavesStructure;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.yml.MainConfig;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.inventory.ItemStack;
import org.bukkit.scheduler.BukkitRunnable;

public class CleanRunner
extends BukkitRunnable {
    private final TreeStructure me;
    private final int offset;
    private final Set<Block> removeBlocks;
    public static TreeAssistDebugger debug;
    private final Material sapling;
    private final boolean cleanUpLeaves;
    private final List<Material> leafMaterials;

    public CleanRunner(TreeStructure tree, int offset, Set<Block> removeBlocks, Material sapling, boolean cleanUpLeaves, List<Material> leafMaterials) {
        this.me = tree;
        this.offset = offset;
        this.removeBlocks = removeBlocks;
        this.sapling = sapling;
        this.cleanUpLeaves = cleanUpLeaves;
        this.leafMaterials = leafMaterials;
    }

    public void run() {
        ItemStack breakTool;
        boolean generateDrops = this.me instanceof LeavesStructure && TreeAssist.instance.config().getBoolean(MainConfig.CFG.DESTRUCTION_FAST_LEAF_DECAY_REGULAR_DROPS);
        debug.i("CleanRunner: will generate drops: " + generateDrops);
        ItemStack itemStack = breakTool = generateDrops ? new ItemStack(Material.AIR, 1) : null;
        if (this.offset < 0) {
            for (Block block : this.removeBlocks) {
                if (this.sapling.equals((Object)block.getType())) {
                    debug.i("CleanRunner 1: skipping breaking a sapling");
                    continue;
                }
                if (block.getType().isAir()) {
                    debug.i("CleanRunner 1: skipping air");
                    continue;
                }
                if (!this.cleanUpLeaves && this.leafMaterials.contains(block.getType())) {
                    debug.i("CleanRunner 1: skipping leaf");
                    continue;
                }
                debug.i("CleanRunner - breaking block A: " + BlockUtils.printBlock(block));
                BlockUtils.breakBlock(null, block, breakTool, block.getY() - 1);
            }
        } else {
            for (Block block : this.removeBlocks) {
                if (this.sapling.equals((Object)block.getType())) {
                    debug.i("CleanRunner 2: skipping breaking a sapling");
                    continue;
                }
                if (block.getType().isAir()) {
                    debug.i("CleanRunner 2: skipping air");
                    continue;
                }
                if (!this.cleanUpLeaves && this.leafMaterials.contains(block.getType())) {
                    debug.i("CleanRunner 2: skipping leaf");
                    continue;
                }
                debug.i("CleanRunner - breaking block B: " + BlockUtils.printBlock(block));
                BlockUtils.breakBlock(null, block, breakTool, block.getY() - 1);
                TreeAssist.instance.blockList.logBreak(block, null);
                this.removeBlocks.remove(block);
                return;
            }
        }
        this.me.plantSaplings();
        this.removeBlocks.clear();
        this.me.setValid(false);
        this.me.setFailReason(FailReason.INVALID_BLOCK);
        try {
            TreeAssist.instance.treeRemove(this.me);
            this.cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

