/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.externals;

import com.sk89q.worldedit.bukkit.BukkitAdapter;
import com.sk89q.worldguard.WorldGuard;
import com.sk89q.worldguard.protection.flags.Flag;
import com.sk89q.worldguard.protection.flags.StateFlag;
import com.sk89q.worldguard.protection.flags.registry.FlagConflictException;
import com.sk89q.worldguard.protection.flags.registry.FlagRegistry;
import com.sk89q.worldguard.protection.regions.RegionContainer;
import com.sk89q.worldguard.protection.regions.RegionQuery;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.events.TASaplingBreakEvent;
import net.slipcor.treeassist.events.TASaplingPlaceEvent;
import net.slipcor.treeassist.events.TATreeBlockBrokenEvent;
import org.bukkit.Location;
import org.bukkit.block.Block;
import org.bukkit.event.Cancellable;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;

public class WorldGuardListener
implements Listener {
    StateFlag replantFlag = this.tryRegister("treeassist-replant");
    StateFlag autoChopFlag = this.tryRegister("treeassist-autochop");
    StateFlag saplingFlag = this.tryRegister("treeassist-saplingbreak");

    private StateFlag tryRegister(String name) {
        try {
            FlagRegistry registry = WorldGuard.getInstance().getFlagRegistry();
            StateFlag myFlag = new StateFlag(name, true);
            registry.register((Flag)myFlag);
            TreeAssist.instance.getLogger().info("WorldGuard flag added: '" + name + "'");
            return myFlag;
        }
        catch (FlagConflictException e) {
            TreeAssist.instance.getLogger().severe("Flag '" + name + "' is already registered in WorldGuard!");
            return null;
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onTreeBreak(TATreeBlockBrokenEvent event) {
        this.cancelIfProtected(event, event.getBlock(), this.autoChopFlag);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSaplingReplace(TASaplingPlaceEvent event) {
        this.cancelIfProtected(event, event.getBlock(), this.replantFlag);
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    public void onSaplingBreak(TASaplingBreakEvent event) {
        this.cancelIfProtected(event, event.getBlock(), this.saplingFlag);
    }

    private void cancelIfProtected(Cancellable event, Block block, StateFlag flag) {
        if (flag == null) {
            return;
        }
        com.sk89q.worldedit.util.Location loc = BukkitAdapter.adapt((Location)block.getLocation());
        RegionContainer container = WorldGuard.getInstance().getPlatform().getRegionContainer();
        RegionQuery query = container.createQuery();
        if (!query.testState(loc, null, new StateFlag[]{flag})) {
            event.setCancelled(true);
        }
    }
}

