/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.discovery;

import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.configuration.serialization.ConfigurationSerializable;

public class TreeBlock
implements ConfigurationSerializable {
    private final int x;
    private final int y;
    private final int z;
    public final String world;
    public final long time;

    public TreeBlock(Block b, long timestamp) {
        this.x = b.getX();
        this.y = b.getY();
        this.z = b.getZ();
        this.world = b.getWorld().getName();
        this.time = timestamp;
    }

    public TreeBlock(String definition) {
        String[] split = definition.split(";");
        this.x = Integer.parseInt(split[0]);
        this.y = Integer.parseInt(split[1]);
        this.z = Integer.parseInt(split[2]);
        this.time = Long.parseLong(split[3]);
        this.world = split[4];
    }

    public TreeBlock(Map<String, Object> map) {
        this.x = (Integer)map.get("x");
        this.y = (Integer)map.get("y");
        this.z = (Integer)map.get("z");
        this.world = map.get("w").toString();
        this.time = (Long)map.get("t");
    }

    public Block getBukkitBlock() {
        return Bukkit.getWorld((String)this.world).getBlockAt(this.x, this.y, this.z);
    }

    public String getWorld() {
        return this.world;
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public Map<String, Object> serialize() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("w", this.world);
        map.put("x", this.x);
        map.put("y", this.y);
        map.put("z", this.z);
        map.put("t", this.time);
        return map;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other == null) {
            return false;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TreeBlock theOther = (TreeBlock)other;
        if (this.x != theOther.x) {
            return false;
        }
        if (this.y != theOther.y) {
            return false;
        }
        if (this.z != theOther.z) {
            return false;
        }
        return this.world.equals(theOther.world);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
        result = 31 * result + this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.x);
        builder.append(';');
        builder.append(this.y);
        builder.append(';');
        builder.append(this.z);
        builder.append(';');
        builder.append(this.time);
        builder.append(';');
        builder.append(this.world);
        return builder.toString();
    }
}

