/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.discovery;

import java.util.HashSet;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.TreeAssistDebugger;
import net.slipcor.treeassist.discovery.FailReason;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.utils.CommandUtils;
import net.slipcor.treeassist.yml.MainConfig;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;

public class DiscoveryResult {
    public static TreeAssistDebugger debug;
    final TreeConfig config;
    final TreeStructure tree;
    private boolean actions;
    private boolean replant;
    private FailReason reason = null;
    private String failExtra = null;
    private boolean cancel = false;
    private boolean valid = true;
    ItemStack item;
    int damagePredicted;

    public DiscoveryResult(TreeConfig config, TreeStructure tree, FailReason reason) {
        this.config = config;
        this.tree = tree;
        this.reason = reason;
        this.valid = false;
        this.actions = false;
    }

    public DiscoveryResult(TreeConfig config, TreeStructure tree, FailReason reason, String failInformation) {
        this(config, tree, reason);
        this.failExtra = failInformation;
    }

    public DiscoveryResult(TreeConfig config, TreeStructure tree, boolean cancel) {
        this.config = config;
        this.tree = tree;
        this.cancel = cancel;
        this.actions = false;
    }

    public DiscoveryResult(TreeConfig config, TreeStructure tree, boolean cancel, ItemStack item, int damagePredicted) {
        this.config = config;
        this.tree = tree;
        this.cancel = cancel;
        this.actions = true;
        this.item = item;
        this.damagePredicted = damagePredicted;
    }

    public TreeConfig getConfig() {
        return this.config;
    }

    public TreeStructure getTree() {
        return this.tree;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public void commitActions(Block block, Player player) {
        if (this.actions) {
            this.tree.maybeReplant(player, block);
            if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.DESTRUCTION_ONLY_ABOVE)) {
                this.tree.removeBlocksBelow(block);
            }
            TreeAssist.instance.treeAdd(this.tree);
            BlockUtils.callExternals(block, player, true);
            CommandUtils.commitTree(player, this.config);
            this.tree.removeTreeLater(player, this.item, this.damagePredicted);
        }
        TreeConfig matchingTreeConfig = this.config;
        TreeStructure matchingTreeStructure = this.tree;
        if (matchingTreeConfig != null) {
            debug.i("Fallback to enforcing something!");
            if (this.replant || matchingTreeConfig.getBoolean(TreeConfig.CFG.REPLANTING_ENFORCE) || TreeAssist.instance.getBlockListener().isReplant(player.getName())) {
                matchingTreeStructure.maybeReplant(player, block);
            }
            if (matchingTreeConfig.getBoolean(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_FORCED_REMOVAL)) {
                if (matchingTreeStructure.extras == null) {
                    matchingTreeStructure.extras = new HashSet<Block>();
                }
                TreeAssist.instance.treeAdd(matchingTreeStructure);
                if (TreeAssist.instance.config().getBoolean(MainConfig.CFG.DESTRUCTION_ONLY_ABOVE)) {
                    matchingTreeStructure.removeBlocksBelow(block);
                }
                BlockUtils.callExternals(block, player, true);
                CommandUtils.commitTree(player, matchingTreeConfig);
                matchingTreeStructure.removeTreeLater(null, null, 0);
            } else {
                matchingTreeStructure.plantSaplings();
            }
        }
    }

    public void debugShow(final Player player) {
        if (this.config == null || this.tree == null || !this.tree.isValid()) {
            TreeAssist.instance.sendPrefixed((CommandSender)player, "Invalid tree!");
            if (this.tree != null && this.tree.discoveryResult != null) {
                TreeAssist.instance.sendPrefixed((CommandSender)player, "Reason: " + (Object)((Object)this.tree.discoveryResult.reason));
                if (this.tree.discoveryResult.getInformation() != null) {
                    TreeAssist.instance.sendPrefixed((CommandSender)player, "More Info: " + this.tree.discoveryResult.getInformation());
                }
            }
            return;
        }
        TreeAssist.instance.sendPrefixed((CommandSender)player, "Showing valid tree #" + System.identityHashCode(this.tree));
        for (Block block : this.tree.trunk) {
            player.sendBlockChange(block.getLocation(), Material.BROWN_STAINED_GLASS.createBlockData());
        }
        for (Block block : this.tree.extras) {
            player.sendBlockChange(block.getLocation(), Material.LIME_STAINED_GLASS.createBlockData());
        }
        if (this.tree.branchMap != null) {
            for (List list : this.tree.branchMap.values()) {
                for (Block block : list) {
                    player.sendBlockChange(block.getLocation(), Material.YELLOW_STAINED_GLASS.createBlockData());
                }
            }
        }
        Bukkit.getScheduler().runTaskLater((Plugin)TreeAssist.instance, new Runnable(){

            @Override
            public void run() {
                TreeAssist.instance.sendPrefixed((CommandSender)player, "Removing valid tree #" + System.identityHashCode(DiscoveryResult.this.tree));
                for (Block block : DiscoveryResult.this.tree.trunk) {
                    player.sendBlockChange(block.getLocation(), block.getType().createBlockData());
                }
                for (Block block : DiscoveryResult.this.tree.extras) {
                    player.sendBlockChange(block.getLocation(), block.getType().createBlockData());
                }
                if (DiscoveryResult.this.tree.branchMap != null) {
                    for (List list : DiscoveryResult.this.tree.branchMap.values()) {
                        for (Block block : list) {
                            player.sendBlockChange(block.getLocation(), block.getType().createBlockData());
                        }
                    }
                }
            }
        }, 200L);
    }

    public FailReason getReason() {
        return this.reason;
    }

    public void setValid(boolean valid) {
        this.valid = valid;
    }

    public boolean isValid() {
        return this.valid;
    }

    public String getInformation() {
        return this.failExtra;
    }

    public ItemStack getTool() {
        return this.item;
    }

    public void setReason(FailReason reason) {
        this.reason = reason;
    }

    public void setOnlyReplant() {
        this.actions = false;
        this.replant = true;
    }
}

