/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.yml.Language;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class CommandToggle
extends CoreCommand {
    public CommandToggle(CorePlugin plugin) {
        super(plugin, "treeassist.toggle", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_TOGGLE.parse());
            return;
        }
        if (args.length > 1 && !args[1].toLowerCase().equals("check")) {
            if (args.length > 2) {
                if (Bukkit.getWorld((String)args[2]) == null) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_NOTFOUND_WORLD.parse(args[2]));
                    return;
                }
                if (!sender.hasPermission("treeassist.toggle.other")) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_TOGGLE_OTHER.parse());
                    return;
                }
                if (TreeAssist.instance.toggleWorld(args[2], args[1])) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_WORLD_ON.parse(args[1], args[2]));
                } else {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_WORLD_OFF.parse(args[1], args[2]));
                }
                return;
            }
            if (Bukkit.getWorld((String)args[1]) == null) {
                if (!sender.hasPermission("treeassist.toggle.other")) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_TOGGLE_OTHER.parse());
                    return;
                }
                if (TreeAssist.instance.toggleGlobal(args[1])) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_ON.parse(args[1]));
                } else {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_OFF.parse(args[1]));
                }
                return;
            }
            if (TreeAssist.instance.toggleWorld(args[1], sender.getName())) {
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_WORLD_ON.parse(args[1]));
            } else {
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_WORLD_OFF.parse(args[1]));
            }
            return;
        }
        if (args.length > 1) {
            if (args.length > 2) {
                if (TreeAssist.instance.isDisabled("global", args[2])) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_OFF.parse(args[2]));
                } else {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_ON.parse(args[2]));
                }
                for (World w : Bukkit.getWorlds()) {
                    String worldName = w.getName();
                    if (TreeAssist.instance.isDisabled(worldName, args[2])) {
                        TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_WORLD_OFF.parse(args[2], worldName));
                        continue;
                    }
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_OTHER_WORLD_ON.parse(args[2], worldName));
                }
                return;
            }
            if (TreeAssist.instance.isDisabled("global", sender.getName())) {
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_OFF.parse());
            } else {
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_ON.parse());
            }
            for (World w : Bukkit.getWorlds()) {
                String worldName = w.getName();
                if (TreeAssist.instance.isDisabled(worldName, sender.getName())) {
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_WORLD_OFF.parse(worldName));
                    continue;
                }
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_WORLD_ON.parse(worldName));
            }
            return;
        }
        if (TreeAssist.instance.toggleGlobal(sender.getName())) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_ON.parse());
        } else {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_TOGGLE_YOU_OFF.parse());
        }
    }

    @Override
    public List<String> completeTab(String[] args) {
        ArrayList<String> results = new ArrayList<String>();
        if (args.length < 2 || args[1].equals("")) {
            ArrayList<String> worlds = new ArrayList<String>();
            for (Object world : Bukkit.getServer().getWorlds()) {
                worlds.add(world.getName());
            }
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                players.add(player.getName());
                if (players.size() < 50) continue;
                break;
            }
            Collections.sort(worlds);
            Collections.sort(players);
            results.addAll(worlds);
            results.addAll(players);
            return results;
        }
        if (args.length > 3) {
            return results;
        }
        if (args.length < 3) {
            String typed = args[1].toLowerCase();
            ArrayList<String> worlds = new ArrayList<String>();
            for (World world : Bukkit.getServer().getWorlds()) {
                if (!world.getName().toLowerCase().startsWith(typed)) continue;
                worlds.add(world.getName());
            }
            ArrayList<String> players = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                if (!player.getName().toLowerCase().startsWith(typed)) continue;
                players.add(player.getName());
                if (players.size() < 50) continue;
                break;
            }
            Collections.sort(worlds);
            Collections.sort(players);
            results.addAll(worlds);
            results.addAll(players);
            return results;
        }
        String typed = args[2].toLowerCase();
        for (World world : Bukkit.getServer().getWorlds()) {
            if (!world.getName().toLowerCase().startsWith(typed)) continue;
            results.add(world.getName());
        }
        Collections.sort(results);
        return results;
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("toggle");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!tg");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist toggle [player/world] {world} - toggle plugin usage for you/others";
    }
}

