/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.yml.Language;
import org.apache.commons.lang.StringUtils;
import org.bukkit.TreeType;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CommandGrowTool
extends CoreCommand {
    public CommandGrowTool(CorePlugin plugin) {
        super(plugin, "treeassist.growtool", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_TOGGLE_GROWTOOL.parse());
            return;
        }
        if (sender instanceof Player) {
            try {
                TreeType species = TreeType.valueOf((String)args[1]);
                Player player = (Player)sender;
                boolean found = false;
                for (ItemStack item : player.getInventory().getContents()) {
                    if (item == null || !item.hasItemMeta() || !TreeAssist.instance.getPlayerListener().isGrowTool(item)) continue;
                    player.getInventory().removeItem(new ItemStack[]{item});
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_GROWTOOL_OFF.parse());
                    found = true;
                    break;
                }
                if (!found) {
                    player.getInventory().addItem(new ItemStack[]{TreeAssist.instance.getPlayerListener().getGrowTool(species)});
                    TreeAssist.instance.sendPrefixed(sender, Language.MSG.SUCCESSFUL_GROWTOOL_ON.parse(species.name()));
                }
            }
            catch (Exception e) {
                String list = StringUtils.join((Object[])TreeType.values(), (String)", ");
                TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_INVALID_TREETYPE.parse(list));
            }
            return;
        }
        TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_ONLY_PLAYERS.parse());
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("growtool");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!gt");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist growtool - toggle the grow tool";
    }

    @Override
    public List<String> completeTab(String[] strings) {
        ArrayList<String> list = new ArrayList<String>();
        if (strings.length > 2) {
            return list;
        }
        for (TreeType type : TreeType.values()) {
            if (strings.length >= 2 && !type.name().contains(strings[1].toUpperCase())) continue;
            list.add(type.name());
        }
        return list;
    }
}

