/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.utils.MaterialUtils;
import net.slipcor.treeassist.yml.Language;
import net.slipcor.treeassist.yml.MainConfig;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockBreakEvent;
import org.bukkit.plugin.Plugin;

public class CommandForceBreak
extends CoreCommand {
    public CommandForceBreak(CorePlugin plugin) {
        super(plugin, "treeassist.forcebreak", Language.MSG.ERROR_INVALID_ARGUMENT_COUNT);
    }

    @Override
    public void commit(CommandSender sender, String[] args) {
        if (!this.hasPerms(sender)) {
            TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_PERMISSION_FORCEBREAK.parse());
            return;
        }
        if (sender instanceof Player) {
            Player player = (Player)sender;
            int radius = TreeAssist.instance.config().getInt(MainConfig.CFG.COMMANDS_FORCE_BREAK_DEFAULT_RADIUS, 10);
            if (args.length > 1) {
                try {
                    radius = Math.max(1, Integer.parseInt(args[1]));
                    int configValue = TreeAssist.instance.config().getInt(MainConfig.CFG.COMMANDS_FORCE_BREAK_MAX_RADIUS, 30);
                    if (radius > configValue) {
                        TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_OUT_OF_RANGE.parse(String.valueOf(configValue)));
                        return;
                    }
                }
                catch (Exception configValue) {
                    // empty catch block
                }
            }
            TreeAssist.instance.setCoolDownOverride(player.getName(), true);
            for (int x = -radius; x <= radius; ++x) {
                for (int y = -radius; y <= radius; ++y) {
                    for (int z = -radius; z <= radius; ++z) {
                        Block b = player.getLocation().add((double)x, (double)y, (double)z).getBlock();
                        if (!MaterialUtils.isLog(b.getType()) || b.getRelative(BlockFace.DOWN).getType() != Material.DIRT && b.getRelative(BlockFace.DOWN).getType() != Material.GRASS_BLOCK && b.getRelative(BlockFace.DOWN).getType() != Material.SAND && b.getRelative(BlockFace.DOWN).getType() != Material.PODZOL) continue;
                        BlockBreakEvent bbe = new BlockBreakEvent(b, player);
                        TreeAssist.instance.getServer().getPluginManager().callEvent((Event)bbe);
                    }
                }
            }
            Bukkit.getScheduler().runTaskLater((Plugin)TreeAssist.instance, () -> TreeAssist.instance.setCoolDownOverride(player.getName(), false), 200L);
            return;
        }
        TreeAssist.instance.sendPrefixed(sender, Language.MSG.ERROR_ONLY_PLAYERS.parse());
    }

    @Override
    public List<String> getMain() {
        return Collections.singletonList("forcebreak");
    }

    @Override
    public List<String> getShort() {
        return Collections.singletonList("!fb");
    }

    @Override
    public String getShortInfo() {
        return "/treeassist forcebreak - force break trees around you";
    }

    @Override
    public List<String> completeTab(String[] strings) {
        return new ArrayList<String>();
    }
}

