/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.blocklists;

import java.util.List;
import me.botsko.prism.Prism;
import me.botsko.prism.actionlibs.ActionsQuery;
import me.botsko.prism.actionlibs.QueryParameters;
import me.botsko.prism.actionlibs.QueryResult;
import me.botsko.prism.actionlibs.RecordingQueue;
import me.botsko.prism.actions.BlockAction;
import me.botsko.prism.actions.Handler;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.blocklists.EmptyBlockList;
import org.bukkit.Bukkit;
import org.bukkit.block.Block;
import org.bukkit.entity.Player;

public class Prism2BlockList
extends EmptyBlockList {
    private final Prism prism = Bukkit.getPluginManager().isPluginEnabled("Prism") ? (Prism)Bukkit.getPluginManager().getPlugin("Prism") : null;

    @Override
    public void initiate() {
        if (this.prism == null) {
            TreeAssist.instance.getLogger().warning("Prism selected as BlockList, but not enabled!");
        }
    }

    @Override
    public boolean isPlayerPlaced(Block block) {
        List results;
        if (this.prism == null || this.lookupTime <= 0) {
            return false;
        }
        QueryParameters parameters = new QueryParameters();
        parameters.setWorld(block.getWorld().toString());
        parameters.setSpecificBlockLocation(block.getLocation());
        parameters.addActionType("block-break");
        parameters.addActionType("block-burn");
        parameters.addActionType("block-spread");
        parameters.addActionType("block-place");
        parameters.addActionType("entity-break");
        parameters.addActionType("entity-explode");
        parameters.setLimit(1);
        parameters.setSinceTime(Long.valueOf(System.currentTimeMillis() - (long)this.lookupTime * 1000L));
        ActionsQuery aq = new ActionsQuery(this.prism);
        QueryResult lookupResult = aq.lookup(parameters);
        if (!lookupResult.getActionResults().isEmpty() && (results = lookupResult.getActionResults()) != null) {
            for (Handler a : results) {
                if (!a.getType().getShortName().equals("block-break")) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void logBreak(Block block, Player player) {
        if (this.prism == null) {
            return;
        }
        BlockAction action = new BlockAction();
        action.setBlock(block);
        action.setActionType("block-break");
        action.setPlayerName(player == null ? "TreeAssist" : player.getName());
        RecordingQueue.addToQueue((Handler)action);
    }
}

