/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist.blocklists;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.slipcor.treeassist.TreeAssist;
import net.slipcor.treeassist.blocklists.EmptyBlockList;
import net.slipcor.treeassist.discovery.TreeBlock;
import net.slipcor.treeassist.utils.MaterialUtils;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class FlatFileBlockList
extends EmptyBlockList {
    private Map<RegionKey, Map<TreeBlock, Long>> mymap = new HashMap<RegionKey, Map<TreeBlock, Long>>();

    private synchronized Map<TreeBlock, Long> getChunkMap(Block block) {
        int cx = block.getX() >> 4;
        int cz = block.getZ() >> 4;
        int rx = cx >> 5;
        int rz = cz >> 5;
        String world = block.getWorld().getName();
        RegionKey rKey = new RegionKey(world, rx, rz);
        return this.getChunkMap(rKey);
    }

    private synchronized Map<TreeBlock, Long> getChunkMap(RegionKey rKey) {
        if (!this.mymap.containsKey(rKey)) {
            HashMap<TreeBlock, Long> map = new HashMap<TreeBlock, Long>();
            try {
                File file;
                File path = new File(TreeAssist.instance.getDataFolder(), rKey.world);
                if (path.isDirectory() && path.exists() && (file = new File(path, rKey.x + "." + rKey.z + ".txt")).exists()) {
                    String line;
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    while ((line = reader.readLine()) != null) {
                        TreeBlock tBlock = new TreeBlock(line);
                        map.put(tBlock, tBlock.time);
                    }
                    reader.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.mymap.put(rKey, map);
        }
        return this.mymap.get(rKey);
    }

    private synchronized Map<TreeBlock, Long> getChunkMap(TreeBlock treeBlock) {
        int cx = treeBlock.getX() >> 4;
        int cz = treeBlock.getZ() >> 4;
        int rx = cx >> 5;
        int rz = cz >> 5;
        String world = treeBlock.getWorld();
        RegionKey rKey = new RegionKey(world, rx, rz);
        return this.getChunkMap(rKey);
    }

    @Override
    public void addBlock(Block block) {
        long time = System.currentTimeMillis();
        Map<TreeBlock, Long> cc = this.getChunkMap(block);
        cc.put(new TreeBlock(block, time), time);
    }

    private void addBlock(TreeBlock treeBlock) {
        Map<TreeBlock, Long> cc = this.getChunkMap(treeBlock);
        cc.put(treeBlock, treeBlock.time);
    }

    @Override
    public void initiate() {
        block14: {
            File configFile = new File(TreeAssist.instance.getDataFolder(), "data.yml");
            try {
                if (!configFile.exists()) break block14;
                YamlConfiguration config = new YamlConfiguration();
                config.load(configFile);
                File backupFile = new File(TreeAssist.instance.getDataFolder(), "data_old.yml");
                if (!backupFile.exists()) {
                    config.save(backupFile);
                }
                if (config.contains("Blocks")) {
                    List list = config.getStringList("Blocks");
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    for (String entry : list) {
                        String[] split = entry.split(";");
                        if (split.length == 4) {
                            try {
                                long time = System.currentTimeMillis();
                                map.put("x", Integer.parseInt(split[0]));
                                map.put("y", Integer.parseInt(split[1]));
                                map.put("z", Integer.parseInt(split[2]));
                                map.put("t", time);
                                map.put("w", split[3]);
                                this.addBlock(new TreeBlock(map));
                            }
                            catch (Exception time) {}
                        } else {
                            if (split.length != 5) continue;
                            try {
                                long time = Long.parseLong(split[3]);
                                map.put("x", Integer.parseInt(split[0]));
                                map.put("y", Integer.parseInt(split[1]));
                                map.put("z", Integer.parseInt(split[2]));
                                map.put("t", time);
                                map.put("w", split[4]);
                                this.addBlock(new TreeBlock(map));
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        map.clear();
                    }
                    config.set("Blocks", null);
                } else if (config.contains("TreeBlocks")) {
                    for (Object o : config.getList("TreeBlocks", new ArrayList())) {
                        this.addBlock((TreeBlock)o);
                    }
                }
                configFile.delete();
            }
            catch (IOException | InvalidConfigurationException e) {
                e.printStackTrace();
            }
        }
        Bukkit.getScheduler().runTaskTimer((Plugin)TreeAssist.instance, () -> this.save(false), 1200L, 1200L);
    }

    @Override
    public boolean isPlayerPlaced(Block block) {
        if (block == null || this.lookupTime <= 0) {
            return false;
        }
        Map<TreeBlock, Long> cc = this.getChunkMap(block);
        if (!cc.containsKey(new TreeBlock(block, 0L))) {
            return false;
        }
        long value = cc.get(new TreeBlock(block, 0L));
        return value + (long)this.lookupTime * 1000L > System.currentTimeMillis();
    }

    @Override
    public void logBreak(Block block, Player player) {
        this.removeBlock(block);
    }

    @Override
    public void removeBlock(Block block) {
        if (block == null) {
            return;
        }
        Map<TreeBlock, Long> cc = this.getChunkMap(block);
        cc.remove(new TreeBlock(block, 0L));
    }

    public int purge() {
        int total = 0;
        ArrayList<RegionKey> keyRemovals = new ArrayList<RegionKey>();
        for (World world : Bukkit.getWorlds()) {
            File path = new File(TreeAssist.instance.getDataFolder(), world.getName());
            if (!path.isDirectory() || !path.exists()) continue;
            for (File file : path.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                String[] vals = file.getName().split("\\.");
                try {
                    int x = Integer.parseInt(vals[0]);
                    int z = Integer.parseInt(vals[1]);
                    RegionKey rKey = new RegionKey(world.getName(), x, z);
                    Map<TreeBlock, Long> blockMap = this.getChunkMap(rKey);
                    ArrayList<TreeBlock> removals = new ArrayList<TreeBlock>();
                    for (TreeBlock block : blockMap.keySet()) {
                        Block bukkitBlock = block.getBukkitBlock();
                        if (MaterialUtils.isLog(bukkitBlock.getType())) continue;
                        removals.add(block);
                    }
                    if (removals.size() <= 0) continue;
                    for (TreeBlock block : removals) {
                        blockMap.remove(block);
                    }
                    this.saveData(rKey, true);
                    total += removals.size();
                    if (blockMap.size() >= 1) continue;
                    keyRemovals.add(rKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (RegionKey key : keyRemovals) {
            this.mymap.remove(key);
        }
        return total;
    }

    public int purge(String worldName) {
        int total = 0;
        File path = new File(TreeAssist.instance.getDataFolder(), worldName);
        if (path.isDirectory() && path.exists()) {
            for (File file : path.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                String[] vals = file.getName().split("\\.");
                try {
                    int x = Integer.parseInt(vals[0]);
                    int z = Integer.parseInt(vals[1]);
                    RegionKey rKey = new RegionKey(worldName, x, z);
                    Map<TreeBlock, Long> blockMap = this.getChunkMap(rKey);
                    if (blockMap.size() <= 0) continue;
                    total += blockMap.size();
                    blockMap.clear();
                    this.saveData(rKey, true);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        ArrayList<RegionKey> removals = new ArrayList<RegionKey>();
        for (RegionKey key : this.mymap.keySet()) {
            if (!key.world.equalsIgnoreCase(worldName)) continue;
            Map<TreeBlock, Long> blockMap = this.getChunkMap(key);
            if (blockMap.size() > 0) {
                total += blockMap.size();
                blockMap.clear();
                this.saveData(key, true);
            }
            removals.add(key);
        }
        for (RegionKey key : removals) {
            this.mymap.remove(key);
        }
        return total;
    }

    public int purge(int days) {
        int total = 0;
        ArrayList<RegionKey> keyRemovals = new ArrayList<RegionKey>();
        for (World world : Bukkit.getWorlds()) {
            File path = new File(TreeAssist.instance.getDataFolder(), world.getName());
            if (!path.isDirectory() || !path.exists()) continue;
            for (File file : path.listFiles()) {
                if (!file.isFile() || !file.getName().endsWith(".txt")) continue;
                String[] vals = file.getName().split("\\.");
                try {
                    int x = Integer.parseInt(vals[0]);
                    int z = Integer.parseInt(vals[1]);
                    RegionKey rKey = new RegionKey(world.getName(), x, z);
                    Map<TreeBlock, Long> blockMap = this.getChunkMap(rKey);
                    ArrayList<TreeBlock> removals = new ArrayList<TreeBlock>();
                    for (TreeBlock block : blockMap.keySet()) {
                        if (block.time >= System.currentTimeMillis() - (long)(days * 24 * 60 * 60 * 1000)) continue;
                        removals.add(block);
                    }
                    if (removals.size() <= 0) continue;
                    for (TreeBlock block : removals) {
                        blockMap.remove(block);
                    }
                    this.saveData(rKey, true);
                    total += removals.size();
                    if (blockMap.size() >= 1) continue;
                    keyRemovals.add(rKey);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        for (RegionKey key : keyRemovals) {
            this.mymap.remove(key);
        }
        return total;
    }

    @Override
    public void save(boolean force) {
        for (RegionKey key : this.mymap.keySet()) {
            this.saveData(key, force);
        }
        this.mymap.clear();
    }

    private void saveData(final RegionKey rKey, boolean force) {
        class RunLater
        implements Runnable {
            RunLater() {
            }

            @Override
            public void run() {
                try {
                    File file;
                    if (!path.exists() || !path.isDirectory()) {
                        path.mkdir();
                    }
                    if (!(file = new File(path, rKey.x + "." + rKey.z + ".txt")).exists() && map.size() > 0) {
                        file.createNewFile();
                    } else if (map.size() < 1) {
                        file.delete();
                        return;
                    }
                    PrintWriter pw = new PrintWriter(file);
                    for (TreeBlock block : map.keySet()) {
                        pw.println(block.toString());
                    }
                    pw.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        final File path = new File(TreeAssist.instance.getDataFolder(), rKey.world);
        final HashMap<TreeBlock, Long> map = new HashMap<TreeBlock, Long>(this.mymap.get(rKey));
        if (force) {
            new RunLater().run();
        } else {
            Bukkit.getScheduler().runTaskAsynchronously((Plugin)TreeAssist.instance, (Runnable)new RunLater());
        }
    }

    static class RegionKey {
        String world;
        int x;
        int z;

        RegionKey(String world, int x, int z) {
            this.world = world;
            this.x = x;
            this.z = z;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.world == null ? 0 : this.world.hashCode());
            result = 31 * result + this.x;
            result = 31 * result + this.z;
            return result;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other == null) {
                return false;
            }
            if (this.getClass() != other.getClass()) {
                return false;
            }
            RegionKey theOther = (RegionKey)other;
            if (this.x != theOther.x) {
                return false;
            }
            if (this.z != theOther.z) {
                return false;
            }
            return this.world.equals(theOther.world);
        }
    }
}

