/*
 * Decompiled with CFR 0.152.
 */
package net.slipcor.treeassist;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.slipcor.treeassist.blocklists.BlockList;
import net.slipcor.treeassist.blocklists.CoreProtectBlockList;
import net.slipcor.treeassist.blocklists.EmptyBlockList;
import net.slipcor.treeassist.blocklists.FlatFileBlockList;
import net.slipcor.treeassist.blocklists.LogBlockBlockList;
import net.slipcor.treeassist.blocklists.Prism2BlockList;
import net.slipcor.treeassist.commands.CommandAddTool;
import net.slipcor.treeassist.commands.CommandConfig;
import net.slipcor.treeassist.commands.CommandDebug;
import net.slipcor.treeassist.commands.CommandDebugTool;
import net.slipcor.treeassist.commands.CommandFindForest;
import net.slipcor.treeassist.commands.CommandForceBreak;
import net.slipcor.treeassist.commands.CommandForceGrow;
import net.slipcor.treeassist.commands.CommandGlobal;
import net.slipcor.treeassist.commands.CommandGrowTool;
import net.slipcor.treeassist.commands.CommandNoReplant;
import net.slipcor.treeassist.commands.CommandPurge;
import net.slipcor.treeassist.commands.CommandReload;
import net.slipcor.treeassist.commands.CommandRemoveTool;
import net.slipcor.treeassist.commands.CommandReplant;
import net.slipcor.treeassist.commands.CommandToggle;
import net.slipcor.treeassist.commands.CommandTool;
import net.slipcor.treeassist.commands.CommandTreeConfig;
import net.slipcor.treeassist.core.CoreCommand;
import net.slipcor.treeassist.core.CoreLanguage;
import net.slipcor.treeassist.core.CoreMetrics;
import net.slipcor.treeassist.core.CorePlugin;
import net.slipcor.treeassist.core.CoreTabCompleter;
import net.slipcor.treeassist.core.CoreUpdater;
import net.slipcor.treeassist.core.TreeAssistDebugger;
import net.slipcor.treeassist.discovery.DiscoveryResult;
import net.slipcor.treeassist.discovery.TreeBlock;
import net.slipcor.treeassist.discovery.TreeStructure;
import net.slipcor.treeassist.externals.WorldGuardListener;
import net.slipcor.treeassist.listeners.PlaceholderAPIListener;
import net.slipcor.treeassist.listeners.TreeAssistBlockListener;
import net.slipcor.treeassist.listeners.TreeAssistPlayerListener;
import net.slipcor.treeassist.listeners.TreeAssistSpawnListener;
import net.slipcor.treeassist.metrics.MetricsLite;
import net.slipcor.treeassist.metrics.MetricsMain;
import net.slipcor.treeassist.runnables.CleanRunner;
import net.slipcor.treeassist.runnables.CoolDownCounter;
import net.slipcor.treeassist.utils.BlockUtils;
import net.slipcor.treeassist.utils.CommandUtils;
import net.slipcor.treeassist.utils.StringUtils;
import net.slipcor.treeassist.utils.ToolUtils;
import net.slipcor.treeassist.yml.Language;
import net.slipcor.treeassist.yml.MainConfig;
import net.slipcor.treeassist.yml.TreeConfig;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.serialization.ConfigurationSerialization;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public class TreeAssist
extends CorePlugin {
    public static Map<String, TreeConfig> treeConfigs = new LinkedHashMap<String, TreeConfig>();
    public static TreeAssist instance;
    public List<Location> saplingLocationList = new ArrayList<Location>();
    private final Map<String, List<String>> disabledMap = new HashMap<String, List<String>>();
    final Map<String, CoreCommand> commandMap = new HashMap<String, CoreCommand>();
    final List<CoreCommand> commandList = new ArrayList<CoreCommand>();
    private final Map<String, CoolDownCounter> coolDowns = new HashMap<String, CoolDownCounter>();
    private final Set<String> coolDownOverrides = new HashSet<String>();
    private final Set<TreeStructure> validTrees = new HashSet<TreeStructure>();
    public static final List<String> defaultTreeDefinitions;
    public boolean Enabled = true;
    public boolean mcMMO = false;
    public boolean jobs = false;
    public boolean aurelium = false;
    public boolean auraskills = false;
    public boolean makeEvents = false;
    private File configFile;
    private MainConfig config;
    public BlockList blockList;
    private WorldGuardListener worldGuard = null;
    private TreeAssistBlockListener listener;
    private TreeAssistPlayerListener playerListener;
    private TreeAssistSpawnListener spawnListener;
    private CoreUpdater updater = null;
    private CoreTabCompleter completer;
    private CoreLanguage language;

    private void checkAureliumSkills() {
        if (this.config.getBoolean(MainConfig.CFG.PLUGINS_USE_AURELIUMSKILLS)) {
            this.aurelium = this.getServer().getPluginManager().isPluginEnabled("AureliumSkills");
            this.auraskills = this.getServer().getPluginManager().isPluginEnabled("AuraSkills");
        } else {
            this.aurelium = false;
            this.auraskills = false;
        }
    }

    private void checkMcMMO() {
        if (this.config.getBoolean(MainConfig.CFG.PLUGINS_USE_MCMMO) || this.config.getBoolean(MainConfig.CFG.PLUGINS_USE_TREEMCMMO)) {
            try {
                if (this.getServer().getPluginManager().isPluginEnabled("mcMMO")) {
                    Class.forName("com.gmail.nossr50.datatypes.skills.PrimarySkillType");
                    this.mcMMO = true;
                }
            }
            catch (ClassNotFoundException e) {
                instance.getLogger().warning("mcMMO classic is not supported, please update to mcMMO 2.X!");
                this.mcMMO = false;
            }
        } else {
            this.mcMMO = false;
        }
    }

    private void checkJobs() {
        this.jobs = this.config.getBoolean(MainConfig.CFG.PLUGINS_USE_JOBS) || this.config.getBoolean(MainConfig.CFG.PLUGINS_USE_TREEJOBS) ? this.getServer().getPluginManager().isPluginEnabled("Jobs") : false;
    }

    private void checkWorldGuard() {
        if (this.config.getBoolean(MainConfig.CFG.PLUGINS_USE_WORLDGUARD) && this.getServer().getPluginManager().getPlugin("WorldGuard") != null) {
            this.worldGuard = new WorldGuardListener();
        }
    }

    private void firstRun() {
        if (!this.configFile.exists()) {
            this.configFile.getParentFile().mkdirs();
            this.saveResource("config.yml", false);
        }
    }

    public TreeAssistBlockListener getBlockListener() {
        return this.listener;
    }

    public TreeAssistPlayerListener getPlayerListener() {
        return this.playerListener;
    }

    public int getCoolDown(Player player) {
        if (this.hasCoolDown(player)) {
            return this.coolDowns.get(player.getName()).getSeconds();
        }
        return 0;
    }

    @Override
    public MainConfig config() {
        return this.config;
    }

    public CoreUpdater getUpdater() {
        return this.updater;
    }

    public boolean hasCoolDown(Player player) {
        if (player.hasPermission("treeassist.bypass.cooldown")) {
            TreeStructure.debug.i("cooldown bypass permission!");
            return false;
        }
        return !this.coolDownOverrides.contains(player.getName()) && this.coolDowns.containsKey(player.getName());
    }

    public boolean isActive(World world) {
        return !this.config.getBoolean(MainConfig.CFG.WORLDS_RESTRICT) || this.config.getStringList(MainConfig.CFG.WORLDS_ENABLED_WORLDS, new ArrayList<String>()).contains(world.getName());
    }

    public boolean isDisabled(String world, String player) {
        if (this.disabledMap.containsKey("global") && this.disabledMap.get("global").contains(player)) {
            return true;
        }
        if (this.disabledMap.containsKey(world)) {
            return this.disabledMap.get(world).contains(player);
        }
        return false;
    }

    public void loadCommands() {
        this.commandList.clear();
        this.commandMap.clear();
        this.completer = null;
        new CommandAddTool(this).load(this.commandList, this.commandMap);
        new CommandConfig(this).load(this.commandList, this.commandMap);
        new CommandDebug(this).load(this.commandList, this.commandMap);
        new CommandDebugTool(this).load(this.commandList, this.commandMap);
        new CommandFindForest(this).load(this.commandList, this.commandMap);
        new CommandForceBreak(this).load(this.commandList, this.commandMap);
        new CommandForceGrow(this).load(this.commandList, this.commandMap);
        new CommandGlobal(this).load(this.commandList, this.commandMap);
        new CommandNoReplant(this).load(this.commandList, this.commandMap);
        new CommandPurge(this).load(this.commandList, this.commandMap);
        new CommandReload(this).load(this.commandList, this.commandMap);
        new CommandRemoveTool(this).load(this.commandList, this.commandMap);
        new CommandReplant(this).load(this.commandList, this.commandMap);
        new CommandToggle(this).load(this.commandList, this.commandMap);
        new CommandTool(this).load(this.commandList, this.commandMap);
        new CommandTreeConfig(this).load(this.commandList, this.commandMap);
        new CommandGrowTool(this).load(this.commandList, this.commandMap);
    }

    public boolean onCommand(CommandSender sender, Command cmd, String commandLabel, String[] args) {
        CoreCommand acc = args.length > 0 ? this.commandMap.get(args[0].toLowerCase()) : null;
        String[] newArgs = StringUtils.compress(args);
        if (newArgs == null || newArgs.length == 0) {
            return false;
        }
        if (acc != null) {
            acc.commit(sender, newArgs);
            return true;
        }
        for (CoreCommand cc : this.commandMap.values()) {
            if (!cc.getShort().contains(newArgs[0].toLowerCase())) continue;
            cc.commit(sender, newArgs);
            return true;
        }
        boolean found = false;
        for (CoreCommand command : this.commandList) {
            if (!command.hasPerms(sender)) continue;
            this.sendPrefixed(sender, ChatColor.YELLOW + command.getShortInfo());
            found = true;
        }
        return found;
    }

    public void onDisable() {
        this.getServer().getScheduler().cancelTasks((Plugin)this);
        if (this.blockList instanceof FlatFileBlockList) {
            this.blockList.save(true);
        }
        this.destroyDebugger();
    }

    public void onEnable() {
        String pluginName;
        this.checkAureliumSkills();
        this.checkMcMMO();
        this.checkJobs();
        this.makeEvents = this.config().getBoolean(MainConfig.CFG.PLUGINS_USE_CUSTOM_EVENTS);
        if (this.worldGuard != null) {
            this.getServer().getPluginManager().registerEvents((Listener)this.worldGuard, (Plugin)this);
        }
        this.getServer().getPluginManager().registerEvents((Listener)this.listener, (Plugin)this);
        this.playerListener = new TreeAssistPlayerListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.playerListener, (Plugin)this);
        this.spawnListener = new TreeAssistSpawnListener(this);
        this.getServer().getPluginManager().registerEvents((Listener)this.spawnListener, (Plugin)this);
        if (this.config.getBoolean(MainConfig.CFG.BSTATS_ACTIVE)) {
            CoreMetrics coreMetrics = this.config.getBoolean(MainConfig.CFG.BSTATS_FULL) ? new MetricsMain((Plugin)this) : new MetricsLite((Plugin)this);
        }
        TreeStructure.debug = new TreeAssistDebugger(this, 1);
        CleanRunner.debug = new TreeAssistDebugger(this, 2);
        TreeAssistBlockListener.debug = new TreeAssistDebugger(this, 6);
        TreeAssistSpawnListener.debug = new TreeAssistDebugger(this, 7);
        BlockUtils.debug = new TreeAssistDebugger(this, 8);
        TreeAssistPlayerListener.debug = new TreeAssistDebugger(this, 9);
        CommandUtils.debug = new TreeAssistDebugger(this, 10);
        DiscoveryResult.debug = new TreeAssistDebugger(this, 11);
        this.loadDebugger("Debug", (CommandSender)Bukkit.getConsoleSender());
        this.blockList = this.config.getBoolean(MainConfig.CFG.PLACED_BLOCKS_ACTIVE) ? ("TreeAssist".equalsIgnoreCase(pluginName = this.config.getString(MainConfig.CFG.PLACED_BLOCKS_PLUGIN_NAME, "TreeAssist")) ? new FlatFileBlockList() : ("Prism".equalsIgnoreCase(pluginName) ? new Prism2BlockList() : ("LogBlock".equalsIgnoreCase(pluginName) ? new LogBlockBlockList() : ("CoreProtect".equalsIgnoreCase(pluginName) ? new CoreProtectBlockList() : new EmptyBlockList())))) : new EmptyBlockList();
        this.blockList.initiate();
        this.loadCommands();
        if (this.loadLanguage() != null) {
            this.getPluginLoader().disablePlugin((Plugin)this);
            return;
        }
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            new PlaceholderAPIListener().register();
        }
        this.updater = new CoreUpdater(this, this.getFile(), "treeassist", "https://www.spigotmc.org/resources/treeassist.67436/", MainConfig.CFG.UPDATE_MODE, MainConfig.CFG.UPDATE_TYPE);
    }

    public String loadLanguage() {
        return this.language.load(this.config.getString(MainConfig.CFG.GENERAL_LANGUAGE, "lang_en"));
    }

    public void loadToggles() {
        if (!this.config.getBoolean(MainConfig.CFG.GENERAL_TOGGLE_REMEMBER)) {
            return;
        }
        ConfigurationSection section = this.config.getYamlConfiguration().getConfigurationSection("Toggle");
        if (section == null) {
            return;
        }
        for (String world : section.getKeys(false)) {
            this.disabledMap.put(world, new ArrayList(section.getStringList(world)));
        }
    }

    public void onLoad() {
        instance = this;
        this.language = new Language(this);
        ConfigurationSerialization.registerClass(TreeBlock.class);
        this.configFile = new File(this.getDataFolder(), "config.yml");
        try {
            this.firstRun();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.config = new MainConfig(this, this.configFile);
        this.config.load();
        this.reloadLists();
        this.loadToggles();
        this.listener = new TreeAssistBlockListener(this);
        this.checkWorldGuard();
    }

    public List<String> onTabComplete(CommandSender sender, Command cmd, String alias, String[] args) {
        if (this.completer == null) {
            this.completer = new CoreTabCompleter(true);
        }
        return this.completer.getMatches(sender, this.commandList, args);
    }

    public void reloadLists() {
        File treeFolder = new File(this.getDataFolder().getPath(), "trees");
        boolean hasTrees = treeFolder.exists();
        if (hasTrees) {
            boolean bl = hasTrees = treeFolder.listFiles().length > 1;
        }
        if (!hasTrees) {
            for (String tree : defaultTreeDefinitions) {
                this.saveResource(tree, false);
            }
        }
        TreeStructure.reloadTreeDefinitions();
    }

    public void removeCountDown(String playerName) {
        try {
            this.coolDowns.get(playerName).cancel();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.coolDowns.remove(playerName);
    }

    public void setCoolDown(Player player, TreeConfig config, List<Block> logs) {
        if (player.hasPermission("treeassist.bypass.cooldown")) {
            TreeStructure.debug.i("cooldown bypass permission!");
            return;
        }
        int coolDown = config.getInt(TreeConfig.CFG.AUTOMATIC_DESTRUCTION_COOLDOWN, 0);
        if (coolDown == 0 || this.coolDownOverrides.contains(player.getName())) {
            return;
        }
        if (coolDown < 0) {
            coolDown = ToolUtils.calculateCoolDown(player.getInventory().getItemInMainHand(), logs);
            this.sendPrefixed((CommandSender)player, Language.MSG.INFO_COOLDOWN_WAIT.parse(String.valueOf(coolDown)));
        }
        CoolDownCounter cc = new CoolDownCounter(player, coolDown);
        cc.runTaskTimer((Plugin)this, 20L, 20L);
        this.coolDowns.put(player.getName(), cc);
    }

    public synchronized void setCoolDownOverride(String player, boolean value) {
        if (value) {
            this.coolDownOverrides.add(player);
        } else {
            this.coolDownOverrides.remove(player);
        }
    }

    @Override
    public String getDebugPrefix() {
        return "";
    }

    @Override
    public String getMessagePrefix() {
        return Language.MSG.INFO_PLUGIN_PREFIX.parse();
    }

    public boolean toggleGlobal(String player) {
        return this.toggleWorld("global", player);
    }

    public boolean toggleWorld(String world, String player) {
        boolean result = false;
        if (this.disabledMap.containsKey(world)) {
            if (this.disabledMap.get(world).contains(player)) {
                this.disabledMap.get(world).remove(player);
                result = true;
            } else {
                this.disabledMap.get(world).add(player);
            }
        } else {
            this.disabledMap.put(world, new ArrayList());
            this.disabledMap.get(world).add(player);
        }
        if (this.config.getBoolean(MainConfig.CFG.GENERAL_TOGGLE_REMEMBER)) {
            for (String iterWorld : this.disabledMap.keySet()) {
                ArrayList list = new ArrayList(this.disabledMap.get(iterWorld));
                this.config.getYamlConfiguration().set("Toggle." + iterWorld, list);
            }
            this.config.save();
        }
        return result;
    }

    public void treeAdd(TreeStructure tree) {
        this.validTrees.add(tree);
    }

    public void treeRemove(TreeStructure tree) {
        this.validTrees.remove(tree);
    }

    public Set<TreeStructure> treesThatQualify(TreeConfig config, Block block) {
        return this.treesThatQualify(config, block, 2500);
    }

    public Set<TreeStructure> treesThatQualify(TreeConfig config, Block block, int distanceSquared) {
        HashSet<TreeStructure> checkTrees = new HashSet<TreeStructure>(this.validTrees);
        HashSet<TreeStructure> result = new HashSet<TreeStructure>();
        for (TreeStructure tree : checkTrees) {
            if (!config.equals(tree.getConfig())) continue;
            Location myBlock = block.getLocation();
            Location otherLocation = tree.bottom.getLocation();
            if (!myBlock.getWorld().equals(otherLocation.getWorld()) || !(myBlock.distanceSquared(otherLocation) < (double)distanceSquared)) continue;
            result.add(tree);
        }
        return result;
    }

    static {
        defaultTreeDefinitions = new ArrayList<String>();
        defaultTreeDefinitions.add("trees/default.yml");
        defaultTreeDefinitions.add("trees/overworld/acacia.yml");
        defaultTreeDefinitions.add("trees/overworld/azalea.yml");
        defaultTreeDefinitions.add("trees/overworld/birch.yml");
        defaultTreeDefinitions.add("trees/overworld/cherry.yml");
        defaultTreeDefinitions.add("trees/overworld/dark_oak.yml");
        defaultTreeDefinitions.add("trees/overworld/jungle.yml");
        defaultTreeDefinitions.add("trees/overworld/mangrove.yml");
        defaultTreeDefinitions.add("trees/overworld/oak.yml");
        defaultTreeDefinitions.add("trees/overworld/pale_oak.yml");
        defaultTreeDefinitions.add("trees/overworld/spruce.yml");
        defaultTreeDefinitions.add("trees/overworld/tall_jungle.yml");
        defaultTreeDefinitions.add("trees/overworld/tall_oak.yml");
        defaultTreeDefinitions.add("trees/overworld/tall_spruce.yml");
        defaultTreeDefinitions.add("trees/nether.yml");
        defaultTreeDefinitions.add("trees/nether/crimson_fungus.yml");
        defaultTreeDefinitions.add("trees/nether/thick_crimson_fungus.yml");
        defaultTreeDefinitions.add("trees/nether/thick_warped_fungus.yml");
        defaultTreeDefinitions.add("trees/nether/warped_fungus.yml");
        defaultTreeDefinitions.add("trees/mushroom.yml");
        defaultTreeDefinitions.add("trees/mushroom/mushroom-brown.yml");
        defaultTreeDefinitions.add("trees/mushroom/mushroom-red.yml");
    }
}

